/*
import All.that.stuff.about.copyright.that.you.usually.find.at.the.top.of.applets;
import and.not.killing.anybody;
  Chris Davis - Orbital simulation model 4 june 97.
  Thanks to Dr Andrew Gay.
*/


import java.awt.*;
import java.lang.*;
import java.applet.*;
import java.util.*;
import java.net.*;


public class Orbit extends Applet implements Runnable {
    double elapsed_time = 0;
    double dt = 1.0;               // actual time step
    double dt_requ = 8.0;          // required time step
    double display_dt = 256.0;     // display time step
    static int display_option = 0;        // 0 display refreshed

    Pool pool;
    SpaceCanvas canvas1;

    int frameNumber = -1;
    Thread animatorThread = null;
    boolean frozen = true;

    Label counter;
    Button b1;
    Checkbox checkbox1;

    public String getAppletInfo() {
      return "Orbital Simulation V.0.7\r\n";
    }

    public void init() {
      double m, x, y, xx, yy, v, r;
      int col = 0;
      int n = 0;
      int b = 0;
      boolean bodyok;
      String datafilename;

      //Body pool
      pool = new Pool( this );

      // set up the GUI
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        setLayout(gridBag);

        b1 = new Button(" Start/Stop ");
        c.gridwidth = GridBagConstraints.EAST;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight= 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridBag.setConstraints(b1, c);
        add(b1);

        checkbox1 = new Checkbox("Motion trails");
        checkbox1.setState(false);
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight= 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridBag.setConstraints(checkbox1, c);
        add(checkbox1);

        counter = new Label("    bodies");
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight= 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridBag.setConstraints(counter, c);
        add(counter);

        canvas1 = new SpaceCanvas(pool);
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight= 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridBag.setConstraints(canvas1, c);
        add(canvas1);

        validate();


      // get the data for each body in the simulation

      try {
        datafilename = new String(getParameter("DATA_FILE_NAME"));
      } catch( Exception e ) {
        datafilename = new String("mysetup.conf");
      }
      System.out.println( datafilename );

        Properties properties = new Properties();
        try {
          properties.load((new URL(getCodeBase(), datafilename)).openStream());
        } catch (Exception e){
                System.out.println("Can't open URL");
        }
//      properties.list( System.out );

        StringTokenizer st = new StringTokenizer(
               properties.getProperty("bodies"), ",");
        String name;

        while(st.hasMoreTokens()) {
          name = st.nextToken();
          bodyok = true;
          try {
                m = Double.valueOf(properties.getProperty(name+".m")).doubleValue();
                r = Double.valueOf(properties.getProperty(name+".r")).doubleValue();
                x = Double.valueOf(properties.getProperty(name+".x")).doubleValue();
                y = Double.valueOf(properties.getProperty(name+".y")).doubleValue();
                xx = Double.valueOf(properties.getProperty(name+".xx")).doubleValue();
                yy = Double.valueOf(properties.getProperty(name+".yy")).doubleValue();
                col = Double.valueOf(properties.getProperty(name+".col")).intValue();
 
          } catch (Exception e) {
          // buggered the parameters up
            System.out.println("params messed up" + e);
            x = 0; y= 0; xx = 0; yy = 0; m = 0; r=0;
            bodyok = false;
          }

          if ( bodyok ) {
            pool.init( b, name, x, y, xx, yy, m, col, r );
            b++;
          }
          bodyCount(b);
       }

    }

    public void bodyCount( int n ) {
      counter.setText( n + " Bodies" );
    }

    public void start() {
      if (animatorThread == null) {
         animatorThread = new Thread(this);
         animatorThread.start();
      }
    }

    public void stop() {
      if ( animatorThread != null ) {
        animatorThread.stop();
        animatorThread = null;
      }
    }

    public void destroy() {
    }

    public boolean action(Event e, Object arg) {

        // display trails checkbox
        if (e.target == checkbox1) {
          if ( display_option == 0 ) { display_option = 1; }
          else { display_option = 0; }
          System.out.println("checkbox");
          return true;
        }

        // start/stop button
        if ( e.target == b1 ) {
         frozen = !frozen;
        }

        return true;
    }

    public boolean mouseDown(Event e, int x, int y) {
        return true;
    }


    public void run() {

        Thread.currentThread().setPriority(Thread.MIN_PRIORITY);

        //This is the animation loop.
        while (Thread.currentThread() == animatorThread) {
          try {
            if ( !frozen ) {
              //Advance the animation frame.
              frameNumber++;

              //Display it.
              if ( (elapsed_time % display_dt) == 0 ) {
                canvas1.redraw();
              }

              // Calculate motions in pool of bodies.
              pool.move( dt );

              // add time increment
              elapsed_time = elapsed_time + dt;

              if ( dt > dt_requ ) { dt = dt_requ; }
              if ( dt < dt_requ ) {
                dt = dt * 2;                // gentle start
                if ( dt == dt_requ ) { dt++; }
                System.out.println("dt = " + dt);
              }

              animatorThread.sleep(30);
            } else {
              animatorThread.sleep(500);
            }

          } catch ( InterruptedException e ) {
            stop();
          }
        }
    }
}


// Body class variables, plus constructors and methods    O

class Body {

    public int num;       // unique number         n
    public String name;   // body name
    public int status;    // body status 3=active, 2-1=destroy, 0=inactive
    public int countdown; // body countdown to destruction
    public double x;      // x locatiom            m
    public double y;      // y location            m
    public double xx;     // x velocity            m/s
    public double yy;     // y velocity            m/s
    public double xxx;    // x acceleration        m/s2
    public double yyy;    // y acceleration        m/s2
    public double m;      // body mass             kg
    public double r;      // body radius           m
    public double p;      // body rotation period  s
    public Color colour;  // body colour
    public int scrx;      // graphics screen x 
    public int scry;      // graphics screen y
    public int scrr;      // graphics screen r

    // explicit default constructor
    public Body() { }

    // body constructor.
    public Body( int n, String name, double x, double y, double xx, double yy, double m, int col, double r ){

      this.name = new String(name);
      this.num = n;
      this.x = x;
      this.y = y;
      this.xx = xx;
      this.yy = yy;
      this.m = m;
      this.p = p;
      this.r = r;
      this.colour = new Color( ((col /(256*256)) & 255),((col/256) & 255), (col & 255) );
      this.status = 3;
      this.countdown = -1;
    }

    // copy one tied body to another
    public void copy_Body( int number, Body that ){
      this.num = number;
      this.name = that.name;
      this.status = that.status;
      this.countdown = that.countdown;
      this.x = that.x;
      this.y = that.y;
      this.xx = that.xx;
      this.yy = that.yy;
      this.xxx = that.xxx;
      this.yyy = that.yyy;
      this.m = that.m;
      this.p = that.p;
      this.r = that.r;
      this.colour = that.colour;
    }


    // Reset acceleration to zero
    public void zero_acceleration() {

      this.xxx = 0;
      this.yyy = 0;
    }

    // Calculate accelerations due to gravitational attraction.
    public void add_gravitational_acceleration( Body that ) {
      double x, y, r, a;
      double G = .00000000006673;

      if ( (this.status == 3) & (that.status == 3) ) {
        x = this.x - that.x;                 // x distance from m
        y = this.y - that.y;                 // y distance ..   ..
        r = Math.sqrt(x * x + y * y);        // distance   ..   ..
        a = -(G * that.m) / (r * r);         // acceleration towards that
        this.xxx = this.xxx + a * x / r;     // x component of accel
        this.yyy = this.yyy + a * y / r;     // y component of accel
        a = (G * this.m) / (r * r);          // acceleration towards this
        that.xxx = that.xxx + a * x / r;     // x component of accel
        that.yyy = that.yyy + a * y / r;     // y component of accel
      }
    }


    // Calculate new body speed after time t
    public void new_speed( double t ){

      if ( this.status == 3 ) {
        this.xx = this.xx + this.xxx * t;       // new x velocity
        this.yy = this.yy + this.yyy * t;       // new y velocity
      }
    }

    // Calculate new body position after time t
    public void new_position( double t ){

      if ( this.status == 3 ) {
        this.x = this.x + this.xx * t;         // new x
        this.y = this.y + this.yy * t;         // new y
      }
    }

    // Calculate closest approach:
    public int closest_approach( Body that, double dt, Body bod[] ) {
      double a, b, c, d, t;
      double dlx, dly, dvx, dvy;
      int dbn;

      dbn = -1;

      if ( (this.status == 3) && (that.status == 3) ) {
        dlx = this.x - that.x;           
        dly = this.y - that.y;
        d = Math.sqrt( dlx * dlx + dly * dly );

        if ( d <= (this.r + that.r) )  {

          // check that current distance  < sum of radii
          dbn = combine_bodies( that );
        } else {

          // Check that closest approach after time t < sum of radii.
          // The distance squared between the two bodies after time t
          // is a quadratic function a.t.t + b.t + c. a and c are always
          // +ve, but b can be +ve or -ve. The bodies approach each other
          // when b is -ve. Closest approach occurs when the differential
          // of this function ( 2.a.t - b ) is zero

          dvx = this.xx - that.xx;
          dvy = this.yy - that.yy;
          b = ( 2.0 * dlx * dvx ) + ( 2.0 * dly * dvy );
          if ( b < 0 ) {
            a = dvx*dvx + dvy*dvy;
            c = dlx*dlx + dly*dly;
            t = -b / (2.0 * a);
            if (t <= dt) {
              d = a*t*t + b*t + c;
              if ( d > 0 ) { d = Math.sqrt(d); }
              if ( d <= (this.r + that.r) )  {
                dbn = combine_bodies( that );
              }
            }
          }
        }
      }
      return( dbn );
    }


    // combine 2 bodies into one.
    // returns destroyed body number.
    public int combine_bodies( Body that ) {
      Body ba, bz;

      // heaviest body remains
      if ( this.m >= that.m ) {
        ba = this;
        bz = that;
      } else {
        ba = that;
        bz = this;
      }

      bz.status = bz.status - 1;        // start collision flash destruction

      // position at centroid of 2 masses
      ba.x = (ba.x * ba.m + bz.x * bz.m) / (ba.m + bz.m);
      ba.y = (ba.y * ba.m + bz.y * bz.m) / (ba.m + bz.m);

      // conserve momentum
      ba.xx = (ba.xx * ba.m + bz.xx * bz.m) / (ba.m + bz.m);
      ba.yy = (ba.yy * ba.m + bz.yy * bz.m) / (ba.m + bz.m);

      // increase radius 
      ba.r = ba.r * Math.pow( (ba.m+bz.m)/ba.m , .3333333 );

      // increase mass
      ba.m = ba.m + bz.m;

      System.out.println( "collision" + bz.num );
      return( bz.num );
    }
}



// Pool class variables, constructors and methods                                           
// The pool is a pool of bodies
// 

class Pool {

    int arraysize = 100;                     // max no. of bodies
    public int nbodies = 0;                  // actual no. of bodies
    public Body b[] = new Body[ arraysize ];
    public double v_scale, v_xoffset, v_yoffset;
    Orbit thisApplet;

    // Constructor allows access to Applet
    public Pool( Orbit a ) {
      super();
      thisApplet = a;
    }

    public void init( int n, String name, double x, double y, double xx, double yy, double m, int col, double pr) {

      // Initialize Body
      b[n] = new Body( n, name, x, y, xx, yy, m, col, pr );
      nbodies++;
      v_scale = 0.0001;
      v_xoffset = 150;
      v_yoffset = 150;
      System.out.println( b[n].name );
      System.out.println( col );

    }

    // calculate body motions over interval dt
    public void move( double dt ) {
        double x, y, r, net_angle;
        int n, m, dbn;


        // Zero body accelerations, perform countdown
        for ( n = 0; n < nbodies; n++ ) {
           b[n].zero_acceleration();
        }

        // calculate new body gravitational acceleration
        for ( n = 0; n < nbodies; n++ ){
          for ( m = n + 1; m < nbodies; m++ ){
              b[n].add_gravitational_acceleration( b[m]);
          }
        }

         
        // calculate new body speeds
        for ( n = 0; n < nbodies; n++ ){
          b[n].new_speed( dt );  
        }

        // calculate closest approach between pairs of bodies
        for ( n = 0; n < nbodies; n++ ) {
          for ( m = n + 1; m < nbodies; m++ ){
            dbn = b[n].closest_approach( b[m], dt, b );
          }
        }

        // calculate new body locations after time dt
        for ( n = 0; n < nbodies; n++ ){
          b[n].new_position( dt );
        }

        // remove a dead body
        for ( n = 0; n < nbodies; n++ ){
          if (b[n].status == 0) {
            nbodies = reel_in(n);
            thisApplet.bodyCount(nbodies);
            break;
          }
        }

    }

    // move n+1 body to n body, from n to last body
    // Called when a body dies ( status -> 0 ),
    // this reduces the size of the array and speeds processing.
    public int reel_in( int n ) {
      int m;

        System.out.println( "reel in body " + n );
        for ( m = n; m < nbodies-1; m++ ) {
          b[m].copy_Body( b[m+1].num, b[m+1]);
        }
        m = nbodies-1;
        b[m].status = 0;     // zero status of nth body

        return( m );
    }
}


class SpaceCanvas extends Canvas {
    Dimension offDimension;
    Image offImage;
    Graphics offGraphics;
    Pool pl;
    FactSheet factsheet;


    // Constructor allows access to Pool objects by this class
    public SpaceCanvas( Pool pool) {
        super();
        pl = pool;
        this.setBackground( Color.black );
    }

    public void stop() {

        offGraphics = null;
        offImage = null;
    }

    public boolean handleEvent( Event evt ) {
      if (evt.id == Event.MOUSE_DOWN ) {
        factsheet = new FactSheet( pl, evt.x, evt.y );
      }
      if (evt.id == Event.MOUSE_UP ) {
        factsheet.killFactSheet();
      }
      return true;
    }

    public void redraw() { repaint(); }

    // update calls paint(), otherwise clears the screen.
    public void update(Graphics g) {
      paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = size();

        //Create the offscreen graphics context, if no good one exists.
        if ( (offGraphics == null)
          || (d.width != offDimension.width)
          || (d.height != offDimension.height) ) {
            offDimension = d;
            offImage = createImage(d.width, d.height);
            offGraphics = offImage.getGraphics();
            System.out.println( "Graphics setup" );
        }

        backpaint( offGraphics );

        //Paint the image onto the screen.
        g.drawImage(offImage, 0, 0, this);
    }


    public void backpaint(Graphics offGraphics) {
        int x1, y1, x2, y2;
        int m, n;
        Dimension d = size();

        //If necessary, erase the previous image.
        if ( Orbit.display_option == 0 ) {
          offGraphics.setColor(Color.black);
          offGraphics.fillRect(0, 0, d.width, d.height);
        }

        // display body locations.
        for ( n = 0; n < pl.nbodies; n++ ){
          offGraphics.setPaintMode();
          m = n + 1;
          if (pl.b[n].status == 3) {

            offGraphics.setColor( pl.b[n].colour );
            if ( l_t(pl.b[n].r) == 0 ) {
              offGraphics.drawLine( x_t(pl.b[n].x), y_t(pl.b[n].y) , x_t(pl.b[n].x), y_t(pl.b[n].y) );
            } else {
              x1 = x_t(pl.b[n].x - pl.b[n].r);
              y1 = y_t(pl.b[n].y - pl.b[n].r);
              x2 = l_t(2 * pl.b[n].r);
              y2 = l_t(2 * pl.b[n].r);
              offGraphics.drawOval( x1, y1, x2, y2 );
            }

          // draw impact flashes
          } else if ( pl.b[n].status > 0 ) {
              // when b[n].status = 2 XOR a white flash
              // when b[n].status = 1 XOR out the flash again
              // b[n].status ends up = 0
              offGraphics.setXORMode(Color.black);
              offGraphics.setColor(Color.white);
              offGraphics.drawLine( x_t(pl.b[n].x)-10, y_t(pl.b[n].y), x_t(pl.b[n].x)+10, y_t(pl.b[n].y) );
              offGraphics.drawLine( x_t(pl.b[n].x)-5, y_t(pl.b[n].y)+6, x_t(pl.b[n].x)+5, y_t(pl.b[n].y)-6 );
              offGraphics.drawLine( x_t(pl.b[n].x)-5, y_t(pl.b[n].y)-6, x_t(pl.b[n].x)+5, y_t(pl.b[n].y)+6 );
              pl.b[n].status = pl.b[n].status - 1;
          }
        }
    }

    // x transformation
    public int x_t( double x ) {
      return (int)(pl.v_scale * x + pl.v_xoffset);
    }

    // y transformation
    public int y_t( double y ) {
      return (int)(pl.v_scale * y + pl.v_xoffset);
    }

    // length transformation
    public int l_t( double l ) {
      return (int)(pl.v_scale * l);
    }

}


class FactSheet extends Frame {
    Pool pl;

    // Factsheet frame constructor
    public FactSheet( Pool pool, int x, int y) {
       super("Fact Sheet");
       int n = 23;

       pl = pool;
       n = findNearestBody( x, y );
       setLayout(new GridLayout(5,1));
       add(new Label("Body name:   " + pl.b[n].name ));
       add(new Label("Body x:      " + pl.b[n].x ));
       add(new Label("Body y:      " + pl.b[n].y ));
       add(new Label("Body mass:   " + pl.b[n].m ));
       add(new Label("Body radius: " + pl.b[n].r ));
       pack();
       resize( 200, 100);
       show();
    }

    public void killFactSheet() {
       dispose();
    }

    public int findNearestBody( int x, int y) {
       double x0, y0, d, dx, dy, dmin;
       int n, nearest;

       x0 = ((double)(x - pl.v_xoffset)) / pl.v_scale;
       y0 = ((double)(y - pl.v_yoffset)) / pl.v_scale;

       nearest = 0;
       dmin = 10E+30;                // some large number
       for (n = 0; n < pl.nbodies; n++ ) {
         dx = x0 - pl.b[n].x;
         dy = y0 - pl.b[n].y;
         d = Math.sqrt( dx*dx + dy*dy );
         if ( d < dmin ){
           nearest = n;
           dmin = d;
         }
       }
       return( nearest );
    }

}
